//
//  WDHelpViewController.h
//  RoundTransparentWindow
//
//  Created by Clark Jackson on 10/31/08.
//  Copyright 2008 Western Digital. All rights reserved.
//

@class WebView;
@class LinkButton;

@interface WDHelpViewController : NSWindowController
{
    BOOL                    _isModal;

    NSString                *_flowTag;

    IBOutlet LinkButton* _aboutBtn;
	IBOutlet LinkButton* _supportBtn;

	IBOutlet NSTextField    *_debugText;
    IBOutlet NSTextField    *_headerText;
    IBOutlet NSTextField    *_notificationText;

	IBOutlet WebView        *_webView;
    NSMutableDictionary     *volumeDict;
    
    NSModalSession          session;
    BOOL                    keepGoing;

}

#pragma mark ----------- Accessor Methods  -----------

- (NSMutableDictionary*) volumeDict;
- (void) setVolumeDict:(NSMutableDictionary*)theVolumeDict;
- (void) setContent:(NSString *)path;
- (NSString*)flowTag;
- (void)setFlowTag: (NSString*) value;
- (void)setNotification: (NSString*) value;

#pragma mark ----------- Methods  -----------
- (id) initWithVolumeDict:(NSMutableDictionary*) theVolumeDict;

- (IBAction) openSupportURL:(id)sender;
- (IBAction) showAboutBox:(id)sender;
- (void) showWindow;
- (void) showWindowModally;
- (void) closeWindow;

@end
